/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.lspeed.LsBoxInfo;
import ibm.nways.lspeed.LsBridgeConfig;
import ibm.nways.lspeed.LsBridgeView;
import ibm.nways.lspeed.LsGraphic;
import ibm.nways.lspeed.LsLocalContext;
import ibm.nways.lspeed.eui.ConfigurationAlternateGroup;
import ibm.nways.lspeed.eui.ConfigurationBaseGroup;
import ibm.nways.lspeed.eui.FaultBaseGroup;
import ibm.nways.telnet.TelnetContext;
import java.util.ResourceBundle;

public class JdmLs
extends JdmBrowser {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private static String LsRootFolderTitle = "LsRootFolderTitle";
    private static String ConfigurationGroupTitle = "ConfigurationGroupTitle";
    private static String FaultGroupTitle = "FaultGroupTitle";
    private static String SystemGroupTitle = "SystemGroupTitle";
    private static String CommunicationsGroupTitle = "CommunicationsGroupTitle";
    private static String ServicesGroupTitle = "ServicesGroupTitle";
    private static String SystemGeneralInfoGroupTitle = "SystemGeneralInfoGroupTitle";
    private static String SystemPanelTitle = "SystemPanelTitle";
    private static String SnmpConfigPanelTitle = "SnmpConfigPanelTitle";
    private static String OtherAppsGroupTitle = "OtherAppsGroupTitle";
    private static String MibBrowserTitle = "MibBrowserTitle";
    private static String StartGraphic = "StartGraphic";
    private static String EndGraphic = "EndGraphic";
    private static String StartNavTree = "StartNavTree";
    private static String EndNavTree = "EndNavTree";
    private ResourceBundle myResources;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private GenModel bridgeModel;
    private LsBridgeView bridgeView;
    private LsLocalContext localContext;
    private LsBoxInfo boxInfo;
    private LsBridgeConfig bridgeConfig;
    public boolean loggingOn = false;
    private NavFieldOverride myOverrides;
    static final Object[][] lspeedFieldOverrides = new Object[][]{{"ibm.nways.mib2.model.IpParam.Panel.IpForwarding.access", "read-only"}, {"ibm.nways.mib2.model.IpParam.Panel.IpDefaultTTL.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IfDescr.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrType.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam1.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam2.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam3.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam4.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficDescrParam5.access", "read-only"}, {"ibm.nways.atm.model.TrafficDesc.Panel.AtmTrafficQoSClass.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclAdminStatus.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclReceiveTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVclTransmitTrafficDescrIndex.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAalType.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsTransmitSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5CpcsReceiveSduSize.access", "read-only"}, {"ibm.nways.atm.model.VirtualChannel.Panel.AtmVccAal5EncapsType.access", "read-only"}, {"ibm.nways.sonet.model.SonetMediumSectionLine.SonetMSLInfo.SonetIfLinkTrap.access", "read-only"}, {"ibm.nways.sonet.model.SonetPath.SonetPathInfo.SonetPathIfLinkUpDownTrapEnable.access", "read-only"}, {"ibm.nways.sonet.model.SonetPath.SonetPathInfo.SonetPathCurrentWidth.access", "read-only"}, {"ibm.nways.sonet.model.SonetVT.SonetVTInfo.SonetVTIfLinkUpDownTrapEnable.access", "read-only"}, {"ibm.nways.sonet.model.SonetVT.SonetVTInfo.SonetVTCurrentWidth.access", "read-only"}, {"ibm.nways.lane.model.Lec.Panel.LecMulticastSendType.access", "read-only"}};
    private GraphicPanel deviceGraphicPanel;

    public String getModelTypeName() {
        return "ibm.nways.lspeed.model.LsDevice";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        if (this.getIsApplication()) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        if (this.loggingOn) {
            System.out.println("LS:JdmLs.getDeviceGraphic - entry");
        }
        this.displayMsg(this.myResources.getString(StartGraphic));
        if (this.deviceModel == null) {
            this.deviceModel = (GenModel)this.getModel();
        }
        if (this.boxInfo == null) {
            this.boxInfo = new LsBoxInfo(this.deviceModel, this);
        }
        if (this.boxInfo.getDeviceStatus() != 1) {
            if (this.boxInfo.getLsModuleList().isEmpty()) {
                if (this.loggingOn) {
                    System.out.println("LS:Null graphic");
                }
                this.deviceGraphicPanel = null;
            } else {
                LsGraphic lsGraphic = new LsGraphic(this, this.boxInfo, false);
                this.deviceGraphicPanel = lsGraphic.getGraphicPanel();
                if (this.loggingOn) {
                    System.out.println("LS:Incomplete graphic Drawn. DeviceStatus = " + this.boxInfo.getDeviceStatus());
                }
            }
        } else {
            LsGraphic lsGraphic = new LsGraphic(this, this.boxInfo, true);
            this.deviceGraphicPanel = lsGraphic.getGraphicPanel();
            if (this.loggingOn) {
                System.out.println("LS:Complete Graphic Drawn");
            }
        }
        if (this.loggingOn) {
            System.out.println("LS:JdmLs.getDeviceGraphic - exit");
        }
        this.displayMsg(this.myResources.getString(EndGraphic));
        return this.deviceGraphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        if (this.getIsApplication()) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        if (this.myResources == null) {
            this.myResources = ResourceBundle.getBundle(bundleName);
        }
        this.rootFolder = new NavigationFolder(this.myResources.getString(LsRootFolderTitle));
        this.navContext = this.rootFolder.getNavContext();
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            if (this.loggingOn) {
                System.out.println("LS: JdmLs.getNavTreeRoot deviceModel is NULL!");
            }
        } else {
            if (this.boxInfo != null) {
                this.boxInfo.dispose();
                this.boxInfo = null;
            }
            if (this.bridgeConfig != null) {
                this.bridgeConfig.dispose();
                this.bridgeConfig = null;
            }
            if (this.bridgeView != null) {
                this.bridgeView.dispose();
                this.bridgeView = null;
            }
            if (this.deviceGraphicPanel != null) {
                this.deviceGraphicPanel.dispose();
                this.deviceGraphicPanel = null;
            }
            this.boxInfo = new LsBoxInfo(this.deviceModel, this);
            LsBoxInfo.setInNavContext(this.navContext, this.boxInfo);
            if (this.boxInfo.getDeviceStatus() != 2) {
                this.bridgeConfig = new LsBridgeConfig(this.deviceModel);
                this.bridgeConfig.refresh();
                this.bridgeView = new LsBridgeView(this, this.bridgeConfig);
                this.localContext = new LsLocalContext();
                this.localContext.setBridgeConfig(this.bridgeConfig);
                this.localContext.setBridgeView(this.bridgeView);
                LsLocalContext.setInNavContext(this.navContext, this.localContext);
                LsLocalContext.setVBridgeInNavContext(this.navContext, new Integer(1));
            }
        }
        this.myOverrides = new NavFieldOverride(this.rootFolder.getNavContext(), lspeedFieldOverrides);
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(this.myResources.getString(StartNavTree));
        this.tree = this.getNavigationBrowser();
        this.navContext.put("TREE", this.tree);
        if (this.deviceModel == null || this.boxInfo.getDeviceStatus() == 2) {
            this.buildConfigurationFolder(this.rootFolder, true);
            if (this.loggingOn) {
                System.out.println("LS:Box problems. Device status = " + this.boxInfo.getDeviceStatus());
            }
        } else {
            this.buildConfigurationFolder(this.rootFolder, false);
            this.buildFaultFolder(this.rootFolder);
            this.buildOtherAppsFolder(this.rootFolder);
            this.boxInfo.buildModuleViews();
        }
        this.displayMsg(this.myResources.getString(EndNavTree));
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder, boolean bl) {
        try {
            NavigationFolder navigationFolder2;
            GenModel genModel = (GenModel)this.deviceModel.getComponent("SfConfiguration");
            if (bl) {
                navigationFolder2 = new ConfigurationAlternateGroup(this, genModel);
                this.tree.addEventListener((NavigationBrowserEventListener)((Object)navigationFolder2));
            } else {
                navigationFolder2 = new ConfigurationBaseGroup(this, genModel);
                this.tree.addEventListener((ConfigurationBaseGroup)navigationFolder2);
            }
            navigationFolder2.setIsInitiallyExpanded(false);
            navigationFolder.add(navigationFolder2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        FaultBaseGroup faultBaseGroup = new FaultBaseGroup(this, this.deviceModel);
        this.tree.addEventListener(faultBaseGroup);
        faultBaseGroup.setIsInitiallyExpanded(true);
        navigationFolder.add(faultBaseGroup);
        faultBaseGroup.navigationFolderExpanded(faultBaseGroup);
    }

    private void buildOtherAppsFolder(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = null;
        navigationFolder2 = new NavigationFolder(this.myResources.getString(OtherAppsGroupTitle));
        navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add(navigationFolder2);
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put("telnetContext", telnetContext);
            navigationFolder2.add(navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(this.myResources.getString(MibBrowserTitle), this, snmpContextModel);
            navigationBrowser.addEventListener(browser);
            navigationFolder2.add(browser.getRootFolder());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

